function C=minJ_G(A,B);

%
% Produto min-J_G
%

[m,n]=size(A);

if size(B,1)~=n
	disp('Inner matrix dimensions must agree.');
	return
end

C=ones(m,size(B,2));
for i=1:m
	for j=1:n
		aux=(B(j,:)<=A(i,j));
		C(i,:)=min(C(i,:),aux+~aux*A(i,j));
	end
end