(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     85081,       2540]
NotebookOptionsPosition[     79335,       2365]
NotebookOutlinePosition[     79685,       2380]
CellTagsIndexPosition[     79642,       2377]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "FUN\[CapitalCCedilla]\[CapitalAHat]O", " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], ":=", 
    RowBox[{
     RowBox[{"x", "^", "3"}], " ", "-", " ", 
     RowBox[{"6", " ", 
      RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
     RowBox[{"9", " ", "x"}], " ", "-", " ", "2"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8233583930175085`*^9, 3.823358418032749*^9}, {
  3.8233584972067976`*^9, 3.823358508783752*^9}, {3.8233586276044507`*^9, 
  3.823358629383277*^9}, {3.823610029396659*^9, 3.823610035786563*^9}, {
  3.8236101375164967`*^9, 3.823610147466839*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\"\<fun\[CCedilla]\[ATilde]o\>\"", " "}], "\[IndentingNewLine]", 
 RowBox[{"f", "[", "x", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8233582636907263`*^9, 3.8233583104607277`*^9}, {
   3.8233584258137784`*^9, 3.823358434084276*^9}, {3.8233584811362104`*^9, 
   3.8233584867312803`*^9}, 3.8233585317874784`*^9}],

Cell[BoxData["\<\"fun\[CCedilla]\[ATilde]o\"\>"], "Output",
 CellChangeTimes->{{3.8233582685225544`*^9, 3.823358304442518*^9}, 
   3.8233584344633245`*^9, 3.8233584871897283`*^9, {3.823358526347334*^9, 
   3.8233585333265514`*^9}, 3.823610040288522*^9, 3.823610100854517*^9, 
   3.8236101488352823`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"9", " ", "x"}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 CellChangeTimes->{{3.8233582685225544`*^9, 3.823358304442518*^9}, 
   3.8233584344633245`*^9, 3.8233584871897283`*^9, {3.823358526347334*^9, 
   3.8233585333265514`*^9}, 3.823610040288522*^9, 3.823610100854517*^9, 
   3.823610148838216*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "DERIVADA", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"df", "[", "x_", "]"}], ":=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8233585581223216`*^9, 3.8233585588743334`*^9}, {
  3.8233586326428256`*^9, 3.8233586338735933`*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[{"\"\<derivada\>\"", "\[IndentingNewLine]", 
 RowBox[{"df", "[", "x", "]"}]}], "Input"],

Cell[BoxData["\<\"derivada\"\>"], "Output",
 CellChangeTimes->{3.823358547824445*^9, 3.8236101040559916`*^9, 
  3.823610152558262*^9}],

Cell[BoxData[
 RowBox[{"9", "-", 
  RowBox[{"12", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 CellChangeTimes->{3.823358547824445*^9, 3.8236101040559916`*^9, 
  3.8236101525622625`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xMAX", " ", "E", " ", "xMIN"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"df", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8233585640597515`*^9, 3.8233586403074026`*^9}, {
  3.8233591694995584`*^9, 3.8233592008823705`*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.823358588091547*^9, 3.8233586411466703`*^9, 
  3.8236101069442277`*^9, 3.8236101546168475`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "  ", 
   RowBox[{"MAX", " ", "E", " ", "MIN"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"xmax", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"df", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}],
        "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"xmin", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"df", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}],
        "[", 
       RowBox[{"[", "2", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"xmax", ",", 
     RowBox[{"f", "[", "xmax", "]"}]}], "}"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"xmin", ",", 
     RowBox[{"f", "[", "xmin", "]"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.8233585640597515`*^9, 3.823358706590885*^9}, {
  3.8233592034766207`*^9, 3.823359267083661*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{{3.823358650590093*^9, 3.8233587075662327`*^9}, {
   3.8233592543619475`*^9, 3.823359261091761*^9}, 3.823610158336763*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.823358650590093*^9, 3.8233587075662327`*^9}, {
   3.8233592543619475`*^9, 3.823359261091761*^9}, 3.8236101583388095`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"ZEROS", " ", "DA", " ", "FUN\[CapitalCCedilla]\[CapitalAHat]O"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"x1", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}], 
       "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"x2", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}], 
       "[", 
       RowBox[{"[", "2", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"x3", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}], 
       "[", 
       RowBox[{"[", "3", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "0"}], "}"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "0"}], "}"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x3", ",", "0"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.8233585640597515`*^9, 3.8233586403074026`*^9}, {
  3.8233587275824003`*^9, 3.8233587935185556`*^9}, {3.823359277978002*^9, 
  3.8233593650722237`*^9}, {3.823610167598997*^9, 3.8236102661584024`*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.823358588091547*^9, 3.8233586411466703`*^9, {3.8233587414474154`*^9, 
   3.823358794279225*^9}, {3.823359337060917*^9, 3.8233593657042465`*^9}, 
   3.823610175005207*^9, {3.823610206415162*^9, 3.8236102667468166`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "-", 
    SqrtBox["3"]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.823358588091547*^9, 3.8233586411466703`*^9, {3.8233587414474154`*^9, 
   3.823358794279225*^9}, {3.823359337060917*^9, 3.8233593657042465`*^9}, 
   3.823610175005207*^9, {3.823610206415162*^9, 3.8236102667497787`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    SqrtBox["3"]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.823358588091547*^9, 3.8233586411466703`*^9, {3.8233587414474154`*^9, 
   3.823358794279225*^9}, {3.823359337060917*^9, 3.8233593657042465`*^9}, 
   3.823610175005207*^9, {3.823610206415162*^9, 3.8236102667529182`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "TANGENTE", " ", "NOS", " ", "PONTO", " ", "Z1", " ", "E", " ", "Z3"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tan", "[", 
     RowBox[{"x_", ",", "x0_", ",", "y0_"}], "]"}], ":=", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Limit", "[", 
       RowBox[{
        RowBox[{"df", "[", "x", "]"}], ",", 
        RowBox[{"x", "\[Rule]", "x0"}]}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", " ", "-", "x0"}], ")"}]}], " ", "+", " ", "y0"}]}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"tan", "[", 
     RowBox[{"x", ",", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}], ",", "0"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"tan", "[", 
     RowBox[{"x", ",", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}], ",", "0"}], "]"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8233588628170843`*^9, 3.8233589288019314`*^9}, {
  3.823610374342993*^9, 3.8236104386220903`*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell[BoxData[
 RowBox[{"6", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SqrtBox["3"], "+", "x"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8233589335865355`*^9, 3.8233589562868257`*^9}, {
  3.823610410790592*^9, 3.8236104403235307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SqrtBox["3"], "-", "x"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8233589335865355`*^9, 3.8233589562868257`*^9}, {
  3.823610410790592*^9, 3.823610440333608*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PONTOS", " ", "A"}], ",", " ", "B", ",", " ", "C", ",", " ", 
    "D"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"xA", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tan", "[", 
           RowBox[{"x", ",", 
            RowBox[{"2", "-", 
             SqrtBox["3"]}], ",", "0"}], "]"}], "\[Equal]", 
          RowBox[{"-", "2"}]}], ",", "x"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"xB", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tan", "[", 
           RowBox[{"x", ",", 
            RowBox[{"2", "-", 
             SqrtBox["3"]}], ",", "0"}], "]"}], "\[Equal]", "2"}], ",", "x"}],
         "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"xC", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tan", "[", 
           RowBox[{"x", ",", 
            RowBox[{"2", "+", 
             SqrtBox["3"]}], ",", "0"}], "]"}], "\[Equal]", 
          RowBox[{"-", "2"}]}], ",", "x"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"xD", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tan", "[", 
           RowBox[{"x", ",", 
            RowBox[{"2", "+", 
             SqrtBox["3"]}], ",", "0"}], "]"}], "\[Equal]", "2"}], ",", "x"}],
         "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"xA", ",", "xB", ",", "xC", ",", "xD"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.8233588628170843`*^9, 3.8233589288019314`*^9}, {
  3.8233595454966063`*^9, 3.8233595894289093`*^9}, {3.8233596353661947`*^9, 
  3.823359719188322*^9}, {3.8233598157613688`*^9, 3.8233598216817713`*^9}, {
  3.8233598806132307`*^9, 3.8233599043322124`*^9}, {3.823610518546323*^9, 
  3.823610603160947*^9}, {3.823610635610175*^9, 3.8236107898440585`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.823610790520197*^9, {3.8236108368318577`*^9, 3.8236108565162725`*^9}, 
   3.8236120541748896`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "BASE", " ", "AC", "  ", "E", " ", "ALTURA", "  ", "E", " ", 
    "\[CapitalAAcute]REA"}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"xC", " ", "-", " ", "xA"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "[", "xmax", "]"}], "-", 
    RowBox[{"f", "[", "xmin", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"xC", " ", "-", " ", "xA"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "[", "xmax", "]"}], "-", 
       RowBox[{"f", "[", "xmin", "]"}]}], ")"}], "/", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.823610864957244*^9, 3.823610984760174*^9}},
 Background->RGBColor[0.88, 1, 0.88]],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["3"]}]], "Output",
 CellChangeTimes->{{3.8236108658811502`*^9, 3.823610893159187*^9}, {
   3.8236109475348883`*^9, 3.823610953669462*^9}, 3.823610985303856*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.8236108658811502`*^9, 3.823610893159187*^9}, {
   3.8236109475348883`*^9, 3.823610953669462*^9}, 3.823610985307708*^9}],

Cell[BoxData[
 RowBox[{"4", " ", 
  SqrtBox["3"]}]], "Output",
 CellChangeTimes->{{3.8236108658811502`*^9, 3.823610893159187*^9}, {
   3.8236109475348883`*^9, 3.823610953669462*^9}, 3.823610985309701*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"df", "[", "x", "]"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"df", "[", "x", "]"}], "/", "3"}], "]"}], ",", "Black", ",", 
   "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "xmin"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "xmax"}], ")"}]}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xmax", ",", 
     RowBox[{"f", "[", "xmax", "]"}]}], "}"}], ",", "Blue", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xmin", ",", 
     RowBox[{"f", "[", "xmin", "]"}]}], "}"}], ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.823361360939846*^9, 3.823361370936331*^9}, {
  3.823361768919734*^9, 3.8233619220478325`*^9}, {3.8236164902999682`*^9, 
  3.823616516023121*^9}, {3.823616548986945*^9, 3.8236166382073*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.823616638862545*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"9", "-", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.823616638865593*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"3", "-", 
   RowBox[{"4", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.823616638868529*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.823616638870674*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.8236166388726606`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"3", ",", 
    RowBox[{"-", "2"}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.82336136421712*^9, {3.8233617838633595`*^9, 3.823361866274951*^9}, {
   3.8233618963988533`*^9, 3.823361924335285*^9}, 3.8236164666282444`*^9, 
   3.8236165171940084`*^9, {3.8236165518194237`*^9, 3.8236166388765087`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f(x)=0 [x=2]\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<8 - 24 + 18 - 2 = 0 \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<\!\(\*SuperscriptBox[\(x\), \(3\)]\) - 6 \!\(\*SuperscriptBox[\(x\), \
\(2\)]\) + 9 x - 2 = (\!\(\*SuperscriptBox[\(x\), \(2\)]\) + a x + b) (x-2)\>\
\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<\!\(\*SuperscriptBox[\(x\), \(2\)]\) - 4 x - 1 = 0\>\"", ",", "Black", 
   ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x2", ",", "0"}], "}"}], ",", "Gray", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x3", ",", "0"}], "}"}], ",", "Gray", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823362470505306*^9, 3.823362535112802*^9}, {
  3.8236169632119737`*^9, 3.8236169707119665`*^9}, {3.82361704054812*^9, 
  3.8236171510724845`*^9}, {3.8236171833671045`*^9, 3.823617233234801*^9}, {
  3.8236172948120074`*^9, 3.8236173659957604`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f(x)=0 [x=2]\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.8236173666928015`*^9}],

Cell[BoxData[
 StyleBox["\<\"8 - 24 + 18 - 2 = 0 \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.8236173666957617`*^9}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(x\\), \\(3\\)]\\) - 6 \
\\!\\(\\*SuperscriptBox[\\(x\\), \\(2\\)]\\) + 9 x - 2 = \
(\\!\\(\\*SuperscriptBox[\\(x\\), \\(2\\)]\\) + a x + b) (x-2)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.823617366698743*^9}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(x\\), \\(2\\)]\\) - 4 x - 1 = 0\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.8236173667008743`*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "-", 
     SqrtBox["3"]}], ",", "0"}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0.5],
  FrontFaceColor->GrayLevel[0.5],
  BackFaceColor->GrayLevel[0.5],
  GraphicsColor->GrayLevel[0.5],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0.5]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.8236173667286386`*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "+", 
     SqrtBox["3"]}], ",", "0"}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0.5],
  FrontFaceColor->GrayLevel[0.5],
  BackFaceColor->GrayLevel[0.5],
  GraphicsColor->GrayLevel[0.5],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0.5]]], "Output",
 CellChangeTimes->{{3.823362512615917*^9, 3.823362536121107*^9}, {
   3.823616956302604*^9, 3.8236169711768227`*^9}, 3.823617094256451*^9, 
   3.8236171525126266`*^9, {3.8236172289233847`*^9, 3.8236172345473566`*^9}, 
   3.823617366732628*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z1: \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x1) (x-x1) + y1\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"df", "[", "x", "]"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x1)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"6", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z1: \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"tan", "[", 
      RowBox[{"x", ",", "x2", ",", "0"}], "]"}], "]"}], ",", "Black", ",", 
    "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823362470505306*^9, 3.823362535112802*^9}, {
  3.823362798742795*^9, 3.823362804849419*^9}, {3.8233628441748915`*^9, 
  3.8233629025826273`*^9}, {3.823617687864719*^9, 3.8236178012643466`*^9}, {
  3.8236178500967283`*^9, 3.823617925546906*^9}, {3.8236179947439127`*^9, 
  3.8236180298679333`*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z1: \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.8236180344068737`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x1) (x-x1) + y1\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.8236180344097166`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.823618034413869*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"9", "-", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.8236180344157333`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x1)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.8236180344177523`*^9}}],

Cell[BoxData[
 StyleBox["6",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.8236180344197206`*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z1: \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.823618034421722*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"6", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SqrtBox["3"], "+", "x"}], ")"}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8233628054768686`*^9, {3.823362851279582*^9, 3.823362860644548*^9}, {
   3.823362895208921*^9, 3.823362903595337*^9}, {3.8236176912775326`*^9, 
   3.823617752812113*^9}, {3.823617858526331*^9, 3.8236178657998652`*^9}, {
   3.8236178997699347`*^9, 3.8236179263637295`*^9}, {3.82361800831966*^9, 
   3.823618034424677*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z3: \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x3) (x-x3) + y3\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"df", "[", "x", "]"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<f'(x3)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"6", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z3: \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"tan", "[", 
      RowBox[{"x", ",", "x3", ",", "0"}], "]"}], "]"}], ",", "Black", ",", 
    "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823362470505306*^9, 3.823362535112802*^9}, {
  3.823362798742795*^9, 3.823362804849419*^9}, {3.8233628441748915`*^9, 
  3.8233629025826273`*^9}, {3.823617687864719*^9, 3.8236178012643466`*^9}, {
  3.8236178500967283`*^9, 3.823617925546906*^9}, {3.8236179947439127`*^9, 
  3.8236180298679333`*^9}, {3.8236182643047967`*^9, 3.8236183268006344`*^9}, {
  3.8236183862885084`*^9, 3.823618473278826*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z3: \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738294907`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x3) (x-x3) + y3\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738333397`*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738354454`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"9", "-", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.823618473837351*^9}}],

Cell[BoxData[
 StyleBox["\<\"f'(x3)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738393254`*^9}}],

Cell[BoxData[
 StyleBox["6",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.823618473842347*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z3: \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738443117`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"-", "6"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SqrtBox["3"], "-", "x"}], ")"}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8236182871925707`*^9, 3.823618328542124*^9}, {
  3.823618373429902*^9, 3.8236184738473034`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Input",
 CellChangeTimes->{{3.8236187305845785`*^9, 3.8236187313984604`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"9", " ", "x"}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 CellChangeTimes->{3.8236187317325077`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<E\>\"", ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<- 2 + 9 x - 6 \!\(\*SuperscriptBox[\(x\), \(2\)]\) + \
\!\(\*SuperscriptBox[\(x\), \(3\)]\) = - 2\>\"", ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<x = 0\>\"", ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{"\"\<(0 , -2)\>\"", ",", "Red", ",", "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823363040563819*^9, 3.8233630790758214`*^9}, {
  3.8236186335142326`*^9, 3.823618641506857*^9}, {3.8236186802183523`*^9, 
  3.8236186839134665`*^9}, {3.823618742065889*^9, 3.823618858502471*^9}}],

Cell[BoxData[
 StyleBox["\<\"E\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.823618858837717*^9}}],

Cell[BoxData[
 StyleBox["\<\"- 2 + 9 x - 6 \\!\\(\\*SuperscriptBox[\\(x\\), \\(2\\)]\\) + \
\\!\\(\\*SuperscriptBox[\\(x\\), \\(3\\)]\\) = - 2\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.8236188588405643`*^9}}],

Cell[BoxData[
 StyleBox["\<\"x = 0\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.8236188588435097`*^9}}],

Cell[BoxData[
 StyleBox["\<\"(0 , -2)\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.8236188588445377`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<F [sim\[EAcute]tria]\>\"", ",", "Blue", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<1 \[AGrave] esquerda do m\[AAcute]ximo\>\"", ",", "Red", ",", "25", 
   ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<1 \[AGrave] direita do m\[IAcute]nimo\>\"", ",", "Blue", ",", "25", 
   ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{"\"\<(4 , 2)\>\"", ",", "Blue", ",", "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823363040563819*^9, 3.8233630790758214`*^9}, {
  3.8236186335142326`*^9, 3.823618641506857*^9}, {3.8236186802183523`*^9, 
  3.8236186839134665`*^9}, {3.823618742065889*^9, 3.823618858502471*^9}, {
  3.823618996520288*^9, 3.823619056498928*^9}, {3.823619087157812*^9, 
  3.8236191375650315`*^9}}],

Cell[BoxData[
 StyleBox["\<\"F [sim\[EAcute]tria]\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.823618858837717*^9}, {3.823619005444416*^9, 3.823619057082304*^9}, {
   3.823619108961512*^9, 3.8236191381256275`*^9}}],

Cell[BoxData[
 StyleBox["\<\"1 \[AGrave] esquerda do m\[AAcute]ximo\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.823618858837717*^9}, {3.823619005444416*^9, 3.823619057082304*^9}, {
   3.823619108961512*^9, 3.8236191381294727`*^9}}],

Cell[BoxData[
 StyleBox["\<\"1 \[AGrave] direita do m\[IAcute]nimo\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.823618858837717*^9}, {3.823619005444416*^9, 3.823619057082304*^9}, {
   3.823619108961512*^9, 3.8236191381314983`*^9}}],

Cell[BoxData[
 StyleBox["\<\"(4 , 2)\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.82336305087883*^9, 3.8233630797135935`*^9}, {
   3.8236186364234495`*^9, 3.823618641989623*^9}, 3.8236186850345526`*^9, {
   3.8236187683655214`*^9, 3.823618800474794*^9}, {3.8236188438855686`*^9, 
   3.823618858837717*^9}, {3.823619005444416*^9, 3.823619057082304*^9}, {
   3.823619108961512*^9, 3.823619138135455*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z1 = - 2\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<xA\>\"", ",", "xA"}], "}"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z1 = + 2\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<xB\>\"", ",", "xB"}], "}"}], ",", "Black", ",", "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.8233635301645966`*^9, {3.8236194262530737`*^9, 3.8236194793809896`*^9}, {
   3.823619515859359*^9, 3.823619569672427*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z1 = - 2\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823619479804593*^9, {3.823619537798709*^9, 3.823619570138214*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"xA\"\>", ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"3", " ", 
        SqrtBox["3"]}]}], ")"}]}]}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823619479804593*^9, {3.823619537798709*^9, 3.8236195701431894`*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z1 = + 2\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823619479804593*^9, {3.823619537798709*^9, 3.8236195701461515`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"xB\"\>", ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"3", " ", 
        SqrtBox["3"]}]}], ")"}]}]}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823619479804593*^9, {3.823619537798709*^9, 3.8236195701481466`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z3 = + 2\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<xC\>\"", ",", "xC"}], "}"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<tan em Z3 = - 2\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<xD\>\"", ",", "xD"}], "}"}], ",", "Black", ",", "25", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.8233635301645966`*^9, {3.8236194262530737`*^9, 3.8236194793809896`*^9}, {
   3.823619515859359*^9, 3.8236196294495816`*^9}}],

Cell[BoxData[
 StyleBox["\<\"tan em Z3 = + 2\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.8236196298664417`*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"xC\"\>", ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"3", " ", 
        SqrtBox["3"]}]}], ")"}]}]}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.823619629870401*^9}],

Cell[BoxData[
 StyleBox["\<\"tan em Z3 = - 2\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.823619629873455*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"xD\"\>", ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"3", " ", 
        SqrtBox["3"]}]}], ")"}]}]}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.823619629875408*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<\[CapitalAAcute]rea ABCD\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<(xC-xA)  h \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<4 (xC-xA)\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"xC", "-", "xA"}], ")"}]}], "]"}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<\[CapitalAAcute]rea ABCD\>\"", ",", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"xC", "-", "xA"}], ")"}]}], "]"}]}], "}"}], ",", "Black", ",",
    "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8236203746801863`*^9, 3.8236205057601347`*^9}, {
  3.82362054091306*^9, 3.8236205663809814`*^9}, {3.823622031385324*^9, 
  3.8236220527362156`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\[CapitalAAcute]rea ABCD\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823620380645749*^9, {3.8236204183469005`*^9, 3.823620506011717*^9}, 
   3.8236205668258967`*^9, {3.8236220434482145`*^9, 3.8236220539401407`*^9}}],

Cell[BoxData[
 StyleBox["\<\"(xC-xA)  h \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823620380645749*^9, {3.8236204183469005`*^9, 3.823620506011717*^9}, 
   3.8236205668258967`*^9, {3.8236220434482145`*^9, 3.8236220539440346`*^9}}],

Cell[BoxData[
 StyleBox["\<\"4 (xC-xA)\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823620380645749*^9, {3.8236204183469005`*^9, 3.823620506011717*^9}, 
   3.8236205668258967`*^9, {3.8236220434482145`*^9, 3.8236220539469767`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"8", " ", 
   SqrtBox["3"]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823620380645749*^9, {3.8236204183469005`*^9, 3.823620506011717*^9}, 
   3.8236205668258967`*^9, {3.8236220434482145`*^9, 3.823622053949968*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"\[CapitalAAcute]rea ABCD\"\>", ",", 
    RowBox[{"8", " ", 
     SqrtBox["3"]}]}], "}"}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.823620380645749*^9, {3.8236204183469005`*^9, 3.823620506011717*^9}, 
   3.8236205668258967`*^9, {3.8236220434482145`*^9, 3.8236220539550056`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<\[CapitalAAcute]rea EMN\>\"", ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<Integra\[CCedilla]\[ATilde]o: f(x) - (-2)\>\"", ",", "Red", ",", "25", 
   ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{"\"\<Limites: xE e xN\>\"", ",", "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<Integrate[f[x]-(-2),{x,0,3}]\>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], "-", 
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", "Black", ",", 
   "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<\[CapitalAAcute]rea EMN\>\"", ",", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "}"}], ",", 
   "Red", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8236209965234184`*^9, 3.8236212190212507`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\[CapitalAAcute]rea EMN\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.8236212198731203`*^9}}],

Cell[BoxData[
 StyleBox["\<\"Integra\[CCedilla]\[ATilde]o: f(x) - (-2)\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.823621219877101*^9}}],

Cell[BoxData[
 StyleBox["\<\"Limites: xE e xN\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.823621219879972*^9}}],

Cell[BoxData[
 StyleBox["\<\"Integrate[f[x]-(-2),{x,0,3}]\"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.82362121988299*^9}}],

Cell[BoxData[
 StyleBox[
  FractionBox["27", "4"],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.823621219886078*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"\[CapitalAAcute]rea EMN\"\>", ",", 
    FractionBox["27", "4"]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.8236210044880857`*^9, {3.823621062473131*^9, 3.82362107963109*^9}, {
   3.8236211378734164`*^9, 3.8236211702208157`*^9}, {3.823621208557386*^9, 
   3.823621219889923*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<\[CapitalAAcute]rea N Z3 C\>\"", ",", "Blue", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<Integrate[f[x]+2,{x,3,xC}] + Integrate[f[x] - \
6(x-2-\!\(\*SqrtBox[\(3\)]\)),{x,xC,2+\!\(\*SqrtBox[\(3\)]\)}]\>\"", ",", 
   "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "+", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "3", ",", "xC"}], "}"}]}], "]"}], " ", "+", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "-", " ", 
       RowBox[{"6", 
        RowBox[{"(", 
         RowBox[{"x", "-", "2", "-", 
          SqrtBox["3"]}], ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xC", ",", 
        RowBox[{"2", "+", 
         SqrtBox["3"]}]}], "}"}]}], "]"}]}], ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<\[CapitalAAcute]rea N Z3 C\>\"", ",", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "+", "2"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "3", ",", "xC"}], "}"}]}], "]"}], " ", "+", " ", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "xC", ",", 
          RowBox[{"2", "+", 
           SqrtBox["3"]}]}], "}"}]}], "]"}]}]}], "}"}], ",", "Blue", ",", 
   "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8236209965234184`*^9, 3.8236212190212507`*^9}, {
  3.823621350498577*^9, 3.8236214745876565`*^9}, {3.823621508224681*^9, 
  3.8236217018537607`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\[CapitalAAcute]rea N Z3 C\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
  3.823621682962291*^9, 3.823621702150981*^9}}],

Cell[BoxData[
 StyleBox["\<\"Integrate[f[x]+2,{x,3,xC}] + Integrate[f[x] - \
6(x-2-\\!\\(\\*SqrtBox[\\(3\\)]\\)),{x,xC,2+\\!\\(\\*SqrtBox[\\(3\\)]\\)}]\"\>\
",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
  3.823621682962291*^9, 3.823621702154954*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["10", "3"]}], "+", 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
  3.823621682962291*^9, 3.823621702159941*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"\[CapitalAAcute]rea N Z3 C\"\>", ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["10", "3"]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
  3.823621682962291*^9, 3.823621702162965*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Style", "[", 
  RowBox[{"\"\<\[CapitalAAcute]rea Z3 F D\>\"", ",", "Blue", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
  "\"\<Integrate[f[x] - \
6(x-2-\!\(\*SqrtBox[\(3\)]\)),{x,2+\!\(\*SqrtBox[\(3\)]\),4}] + Integrate[2 - \
6(x-2-\!\(\*SqrtBox[\(3\)]\)),{x,4,xD}] \>\"", ",", "Black", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], " ", "-", " ", 
       RowBox[{"6", 
        RowBox[{"(", 
         RowBox[{"x", "-", "2", "-", 
          SqrtBox["3"]}], ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"2", "+", 
         SqrtBox["3"]}], ",", "4"}], "}"}]}], "]"}], " ", "+", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"2", " ", "-", " ", 
       RowBox[{"6", 
        RowBox[{"(", 
         RowBox[{"x", "-", "2", "-", 
          SqrtBox["3"]}], ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "4", ",", "xD"}], "}"}]}], "]"}]}], ",", "Black", 
   ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<\[CapitalAAcute]rea N Z3 C\>\"", ",", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], " ", "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"2", "+", 
           SqrtBox["3"]}], ",", "4"}], "}"}]}], "]"}], " ", "+", " ", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"2", " ", "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "4", ",", "xD"}], "}"}]}], "]"}]}]}], "}"}], ",", 
   "Blue", ",", "25", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8236209965234184`*^9, 3.8236212190212507`*^9}, {
  3.823621350498577*^9, 3.8236214745876565`*^9}, {3.823621508224681*^9, 
  3.8236217018537607`*^9}, {3.8236217469481945`*^9, 3.8236218984977736`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\[CapitalAAcute]rea Z3 F D\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
   3.823621682962291*^9, 3.823621702150981*^9}, 3.8236217634819164`*^9, {
   3.8236218617769947`*^9, 3.82362190028998*^9}}],

Cell[BoxData[
 StyleBox["\<\"Integrate[f[x] - \
6(x-2-\\!\\(\\*SqrtBox[\\(3\\)]\\)),{x,2+\\!\\(\\*SqrtBox[\\(3\\)]\\),4}] + \
Integrate[2 - 6(x-2-\\!\\(\\*SqrtBox[\\(3\\)]\\)),{x,4,xD}] \"\>",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
   3.823621682962291*^9, 3.823621702150981*^9}, 3.8236217634819164`*^9, {
   3.8236218617769947`*^9, 3.8236219002939687`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["41", "12"]}], "+", 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
   3.823621682962291*^9, 3.823621702150981*^9}, 3.8236217634819164`*^9, {
   3.8236218617769947`*^9, 3.823621900298956*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"\<\"\[CapitalAAcute]rea N Z3 C\"\>", ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["41", "12"]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.823621583192166*^9, 3.823621640560708*^9}, {
   3.823621682962291*^9, 3.823621702150981*^9}, 3.8236217634819164`*^9, {
   3.8236218617769947`*^9, 3.823621900303022*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", "Red", ",", 
     "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "+", "2"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "3", ",", "xC"}], "}"}]}], "]"}], " ", "+", " ", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "xC", ",", 
          RowBox[{"2", "+", 
           SqrtBox["3"]}]}], "}"}]}], "]"}]}], ",", "Blue", ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], " ", "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"2", "+", 
           SqrtBox["3"]}], ",", "4"}], "}"}]}], "]"}], " ", "+", " ", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"2", " ", "-", " ", 
         RowBox[{"6", 
          RowBox[{"(", 
           RowBox[{"x", "-", "2", "-", 
            SqrtBox["3"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "4", ",", "xD"}], "}"}]}], "]"}]}], ",", "Blue", 
     ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8236247881955037`*^9, 3.823624838043481*^9}}],

Cell[BoxData[
 StyleBox[
  FractionBox["27", "4"],
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{{3.8236247926804714`*^9, 3.8236248385550795`*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["10", "3"]}], "+", 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]}],
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.8236247926804714`*^9, 3.8236248385590615`*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["41", "12"]}], "+", 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]}],
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{{3.8236247926804714`*^9, 3.823624838577013*^9}},
 Background->RGBColor[0.9, 1, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"1.", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "-", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], ",", "Red", ",",
      "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "x", "]"}], "+", "2"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "3", ",", "xC"}], "}"}]}], "]"}]}], " ", "+", 
        RowBox[{"100", " ", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "x", "]"}], "-", " ", 
            RowBox[{"6", 
             RowBox[{"(", 
              RowBox[{"x", "-", "2", "-", 
               SqrtBox["3"]}], ")"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "xC", ",", 
             RowBox[{"2", "+", 
              SqrtBox["3"]}]}], "}"}]}], "]"}]}]}], "]"}], "/", "100."}], ",",
      "Blue", ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "x", "]"}], " ", "-", " ", 
            RowBox[{"6", 
             RowBox[{"(", 
              RowBox[{"x", "-", "2", "-", 
               SqrtBox["3"]}], ")"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"2", "+", 
              SqrtBox["3"]}], ",", "4"}], "}"}]}], "]"}]}], " ", "+", " ", 
        RowBox[{"100", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{"2", " ", "-", " ", 
            RowBox[{"6", 
             RowBox[{"(", 
              RowBox[{"x", "-", "2", "-", 
               SqrtBox["3"]}], ")"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "4", ",", "xD"}], "}"}]}], "]"}]}]}], "]"}], 
      "/", "100."}], ",", "Blue", ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"4", " ", 
      SqrtBox["3"]}], ",", "Black", ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"100", " ", "4", " ", 
        SqrtBox["3"]}], "]"}], "/", "100."}], ",", "Black", ",", "25", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Kalam Bold\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8236247881955037`*^9, 3.823624838043481*^9}, {
  3.823625435353919*^9, 3.8236255562574916`*^9}, {3.8236256332615643`*^9, 
  3.8236256725853415`*^9}}],

Cell[BoxData[
 StyleBox["6.75`",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellChangeTimes->{
  3.8236254412940197`*^9, {3.8236254749679775`*^9, 3.8236255567781086`*^9}, {
   3.8236256468591733`*^9, 3.8236256730491242`*^9}}],

Cell[BoxData[
 StyleBox["0.13`",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{
  3.8236254412940197`*^9, {3.8236254749679775`*^9, 3.8236255567781086`*^9}, {
   3.8236256468591733`*^9, 3.8236256730631123`*^9}}],

Cell[BoxData[
 StyleBox["0.05`",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->RGBColor[0, 0, 1]]], "Output",
 CellChangeTimes->{
  3.8236254412940197`*^9, {3.8236254749679775`*^9, 3.8236255567781086`*^9}, {
   3.8236256468591733`*^9, 3.823625673066078*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"4", " ", 
   SqrtBox["3"]}],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8236254412940197`*^9, {3.8236254749679775`*^9, 3.8236255567781086`*^9}, {
   3.8236256468591733`*^9, 3.8236256730700684`*^9}}],

Cell[BoxData[
 StyleBox["6.93`",
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontFamily->"Kalam Bold",
  FontSize->25,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8236254412940197`*^9, {3.8236254749679775`*^9, 3.8236255567781086`*^9}, {
   3.8236256468591733`*^9, 3.8236256730730596`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Round", "[", 
   RowBox[{"100", " ", "4", 
    SqrtBox["3"]}], "]"}], "/", "100."}]], "Input",
 CellChangeTimes->{{3.8236255727194567`*^9, 3.8236256001241884`*^9}}],

Cell[BoxData["6.93`"], "Output",
 CellChangeTimes->{{3.8236255892173705`*^9, 3.8236256009130526`*^9}}]
}, Open  ]]
},
WindowSize->{775, 697},
WindowMargins->{{297, Automatic}, {-113, Automatic}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 717, 17, 85, "Input"],
Cell[CellGroupData[{
Cell[1300, 41, 355, 5, 69, "Input"],
Cell[1658, 48, 303, 4, 30, "Output"],
Cell[1964, 54, 425, 10, 30, "Output"]
}, Open  ]],
Cell[2404, 67, 407, 10, 66, "Input"],
Cell[CellGroupData[{
Cell[2836, 81, 100, 1, 50, "Input"],
Cell[2939, 84, 134, 2, 30, "Output"],
Cell[3076, 88, 225, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3338, 99, 427, 12, 66, "Input"],
Cell[3768, 113, 300, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4105, 126, 1291, 38, 142, "Input"],
Cell[5399, 166, 215, 4, 30, "Output"],
Cell[5617, 172, 236, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5890, 182, 1960, 57, 180, "Input"],
Cell[7853, 241, 316, 6, 30, "Output"],
Cell[8172, 249, 354, 8, 37, "Output"],
Cell[8529, 259, 354, 8, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8920, 272, 1115, 32, 147, "Input"],
Cell[10038, 306, 262, 7, 37, "Output"],
Cell[10303, 315, 258, 7, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10598, 327, 2701, 76, 247, "Input"],
Cell[13302, 405, 784, 29, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14123, 439, 793, 21, 104, "Input"],
Cell[14919, 462, 204, 4, 33, "Output"],
Cell[15126, 468, 170, 2, 30, "Output"],
Cell[15299, 472, 204, 4, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15540, 481, 1641, 42, 126, "Input"],
Cell[17184, 525, 511, 13, 52, "Output"],
Cell[17698, 540, 607, 17, 52, "Output"],
Cell[18308, 559, 581, 16, 52, "Output"],
Cell[18892, 577, 662, 20, 52, "Output"],
Cell[19557, 599, 573, 15, 52, "Output"],
Cell[20133, 616, 593, 16, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20763, 637, 1656, 37, 154, "Input"],
Cell[22422, 676, 520, 13, 52, "Output"],
Cell[22945, 691, 528, 13, 52, "Output"],
Cell[23476, 706, 678, 15, 52, "Output"],
Cell[24157, 723, 566, 13, 52, "Output"],
Cell[24726, 738, 598, 17, 57, "Output"],
Cell[25327, 757, 596, 17, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25960, 779, 1943, 43, 202, "Input"],
Cell[27906, 824, 621, 15, 52, "Output"],
Cell[28530, 841, 628, 15, 52, "Output"],
Cell[29161, 858, 613, 15, 52, "Output"],
Cell[29777, 875, 711, 19, 52, "Output"],
Cell[30491, 896, 616, 15, 52, "Output"],
Cell[31110, 913, 603, 15, 52, "Output"],
Cell[31716, 930, 619, 15, 52, "Output"],
Cell[32338, 947, 719, 20, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33094, 972, 2070, 45, 221, "Input"],
Cell[35167, 1019, 392, 11, 52, "Output"],
Cell[35562, 1032, 399, 11, 52, "Output"],
Cell[35964, 1045, 386, 11, 52, "Output"],
Cell[36353, 1058, 480, 15, 52, "Output"],
Cell[36836, 1075, 387, 11, 52, "Output"],
Cell[37226, 1088, 372, 11, 52, "Output"],
Cell[37601, 1101, 392, 11, 52, "Output"],
Cell[37996, 1114, 490, 16, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38523, 1135, 124, 2, 30, "Input"],
Cell[38650, 1139, 227, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38914, 1151, 1104, 23, 150, "Input"],
Cell[40021, 1176, 535, 13, 52, "Output"],
Cell[40559, 1191, 649, 14, 52, "Output"],
Cell[41211, 1207, 541, 13, 52, "Output"],
Cell[41755, 1222, 544, 13, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42336, 1240, 1209, 27, 145, "Input"],
Cell[43548, 1269, 652, 14, 52, "Output"],
Cell[44203, 1285, 670, 14, 52, "Output"],
Cell[44876, 1301, 669, 14, 52, "Output"],
Cell[45548, 1317, 637, 14, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46222, 1336, 1037, 24, 126, "Input"],
Cell[47262, 1362, 368, 11, 52, "Output"],
Cell[47633, 1375, 552, 19, 73, "Output"],
Cell[48188, 1396, 370, 11, 52, "Output"],
Cell[48561, 1409, 552, 19, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49150, 1433, 1039, 24, 126, "Input"],
Cell[50192, 1459, 321, 10, 52, "Output"],
Cell[50516, 1471, 501, 18, 73, "Output"],
Cell[51020, 1491, 319, 10, 52, "Output"],
Cell[51342, 1503, 501, 18, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51880, 1526, 1422, 34, 126, "Input"],
Cell[53305, 1562, 457, 12, 52, "Output"],
Cell[53765, 1576, 444, 12, 52, "Output"],
Cell[54212, 1590, 442, 12, 52, "Output"],
Cell[54657, 1604, 460, 14, 57, "Output"],
Cell[55120, 1620, 544, 16, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55701, 1641, 1771, 47, 126, "Input"],
Cell[57475, 1690, 508, 13, 52, "Output"],
Cell[57986, 1705, 524, 13, 52, "Output"],
Cell[58513, 1720, 499, 13, 52, "Output"],
Cell[59015, 1735, 485, 13, 52, "Output"],
Cell[59503, 1750, 473, 14, 75, "Output"],
Cell[59979, 1766, 577, 16, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60593, 1787, 2271, 62, 239, "Input"],
Cell[62867, 1851, 428, 11, 52, "Output"],
Cell[63298, 1864, 501, 13, 103, "Output"],
Cell[63802, 1879, 474, 16, 73, "Output"],
Cell[64279, 1897, 589, 18, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64905, 1920, 2542, 69, 214, "Input"],
Cell[67450, 1991, 504, 12, 52, "Output"],
Cell[67957, 2005, 613, 14, 109, "Output"],
Cell[68573, 2021, 552, 17, 73, "Output"],
Cell[69128, 2040, 667, 19, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69832, 2064, 2271, 66, 209, "Input"],
Cell[72106, 2132, 406, 12, 91, "Output"],
Cell[72515, 2146, 488, 16, 89, "Output"],
Cell[73006, 2164, 487, 16, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73530, 2185, 3278, 92, 358, "Input"],
Cell[76811, 2279, 435, 12, 52, "Output"],
Cell[77249, 2293, 435, 12, 52, "Output"],
Cell[77687, 2307, 433, 12, 52, "Output"],
Cell[78123, 2321, 442, 14, 57, "Output"],
Cell[78568, 2337, 410, 12, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79015, 2354, 199, 5, 42, "Input"],
Cell[79217, 2361, 102, 1, 30, "Output"]
}, Open  ]]
}
]
*)

