%
% Exemplo Espirais
%
clear

%load dados_two_spirals_XY_944
load dados_donuts_XY_1000

n=fix(size(X,1)/4);

alt=randperm(size(X,1));
X=X(alt,:);
Y=Y(alt);

% Treinamento
P=X(1:2*n,:)'; 
cP=Y(1:2*n)'>=0;

% Validacao
V=X(2*n+1:3*n,:)'; 
cV=Y(2*n+1:3*n)'>=0;

% Teste
T=X(3*n+1:4*n,:)'; 
cT=Y(3*n+1:4*n)'>=0;

clear X; clear Y; clear alt;

[p,W,erro,ET]=LearnSLMP(P,cP,V,cV);
figure(2);
plot(1:length(erro),erro,'--b',1:length(ET),ET,'-r');
legend('Erro Treinamento','Erro Validacao');

[aux,ind]=min(ET);

disp('Numero de Dendritos');
disp(ind);

W=W(:,1:ind,:);
p=p(1:ind);

y=SLMP(p,W,T);
Er=sum(abs(y-cT))/length(cT);
disp('Erro')
disp(Er)


figure(1);
verclasse(p,W,T,cT)

