%
% Experimento Computacional;
%
clear

% Conjunto de Treinamento;
n_P=500;
for i=1:n_P
        if rand<=0.5
            P(:,i)=randn(2,1);
            cP(i)=1;
        else
            P(:,i)=2*randn(2,1)+[2;1];
            cP(i)=0;
        end
end
c1=find(cP);
c2=find(1-cP);
plot(P(1,c1),P(2,c1),'*b',P(1,c2),P(2,c2),'xr','MarkerSize',12);
print -depsc experimento.eps

% Conjunto de Validao;
n_V=250;
for i=1:n_V
        if rand<=0.5
            V(:,i)=randn(2,1);
            cV(i)=1;
        else
            V(:,i)=2*randn(2,1)+[2;1];
            cV(i)=0;
        end
end
     
n_T=250;
for i=1:n_T
        if rand<=0.5
            T(:,i)=randn(2,1);
            cT(i)=1;
        else
            T(:,i)=2*randn(2,1)+[2;1];
            cT(i)=0;
        end
end     

[p,W,erro,EV,ET]=LearnSLMP(P,cP,V,cV,T,cT);
figure(2);
plot(1:length(erro),erro,'--k',1:length(EV),EV,'-.b',1:length(ET),ET,'-r');
legend('Erro Treinamento','Erro Validao','Erro Teste');
print -depsc experimento1.eps

[aux,ind]=min(EV);

disp('Aprendizado Construtivo');

disp('Numero de Dendritos');
disp(ind);

disp('Erro Validao');
disp(aux)

disp('Erro Teste')
disp(ET(ind))

W=W(:,1:ind,:);
p=p(1:ind);
y=SLMP(p,W,T);
figure(1);
verclasse(p,W,T,cT)
print -depsc experimento2.eps

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

[p,W,erro,EV,ET]=LearnSLMPA(P,cP,V,cV,T,cT);
figure(2);
plot(1:length(erro),erro,'--k',1:length(EV),EV,'-.b',1:length(ET),ET,'-r');
legend('Erro Treinamento','Erro Validao','Erro Teste');
print -depsc experimentoA1.eps

[aux,ind]=min(EV);

disp('Aprendizado Construtivo Alternativo');

disp('Numero de Dendritos');
disp(ind);

disp('Erro Validao');
disp(aux)

disp('Erro Teste')
disp(ET(ind))

W=W(:,1:ind,:);
p=p(1:ind);
y=SLMP(p,W,T);
figure(1);
verclasse(p,W,T,cT)
print -depsc experimentoA2.eps

%
% Perceptrons;
%

%disp('Numero de Dendritos / SLMP');
%disp([mean(ndendritos),mean(ndendritosA)]);

%disp('Epocas / MLP');
%disp(mean(Nepoch));

%disp('Erros: SLMP1, SLMP2, MLP')
%disp([min(ET),min(ETA),mean(ErroP)]);