%
% Exemplo Espirais
%
clear

load dados_donuts_XY_1000

n=fix(size(X,1)/4);

alt=randperm(size(X,1));
X=X(alt,:);
Y=Y(alt);

c1=find(Y>0);
c2=find(Y<0);
plot3(X(c1,1),X(c1,2),X(c1,3),'*b',X(c2,1),X(c2,2),X(c2,3),'xr','MarkerSize',12);

% Treinamento
P=X(1:2*n,:)'; 
cP=Y(1:2*n)'>=0;

% Validacao
V=X(2*n+1:3*n,:)'; 
cV=Y(2*n+1:3*n)'>=0;

% Teste
T=X(3*n+1:4*n,:)'; 
cT=Y(3*n+1:4*n)'>=0;

clear X; clear Y; clear alt;

[p,W,erro,EV,ET]=LearnSLMP(P,cP,V,cV,T,cT);
figure(2);
plot(1:length(erro),erro,'--k',1:length(EV),EV,'-.b',1:length(ET),ET,'-r');
legend('Erro Treinamento','Erro Validao','Erro Teste');
print -depsc donuts1.eps

[aux,ind]=min(EV);

disp('Aprendizado Construtivo');

disp('Numero de Dendritos');
disp(ind);

disp('Erro Validao');
disp(aux)

disp('Erro Teste')
disp(ET(ind))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

[p,W,erro,EV,ET]=LearnSLMPA(P,cP,V,cV,T,cT);
figure(2);
plot(1:length(erro),erro,'--k',1:length(EV),EV,'-.b',1:length(ET),ET,'-r');
legend('Erro Treinamento','Erro Validao','Erro Teste');
print -depsc donutsA1.eps

[aux,ind]=min(EV);

disp('Aprendizado Construtivo Alternativo');

disp('Numero de Dendritos');
disp(ind);

disp('Erro Validao');
disp(aux)

disp('Erro Teste')
disp(ET(ind))