function [p,W,erro,EV,ET]=LearnSLMP(X,c,V,cV,T,cT);

tol=1.e-4;
erro=zeros(1,2);
ET=zeros(1,2);

[N M]=size(X);

if nargin>2
    MV=length(cV);
end
if nargin>4
    MT=length(cT);
end 

k=1;
c1=find(c);
W(:,k,1)=-min(X(:,c1),[],2);
W(:,k,2)=-max(X(:,c1),[],2);
p(1)=1;
%c2=find(1-c);
y=SLMP(p,W,X);

if nargin>2
    yV=SLMP(p,W,V);
    EV(k)=norm(yV-cV,1)/MV;
end
if nargin>4
    yT=SLMP(p,W,T);
    ET(k)=norm(yT-cT,1)/MT;
end
 

erro(k)=norm(y-c,1)/M;
misc=find(abs(y-c).*[1:M]);

while length(misc)&(k<200)
    k=k+1;
    p(k)=-1;
    W(:,k,1)=inf*ones(N,1);
    W(:,k,2)=-inf*ones(N,1);
    D=c1;
    gamma=randperm(length(misc));
    gamma=misc(gamma(1));
    while length(D)
        mu=inf;
        for i=1:length(D);
            normachess=norm(X(:,gamma)-X(:,D(i)),inf);
            if normachess<mu
                mu=normachess;
                xi=D(i);
            end
        end
        ind=[];
        for i=1:N
            if abs(X(i,gamma)-X(i,xi))==mu
                ind=[ind,i];
            end
        end
        for i=1:length(ind)
            if X(ind(i),xi)<X(ind(i),gamma)
                W(ind(i),k,1)=-X(ind(i),xi);
            end
            if X(ind(i),xi)>X(ind(i),gamma)
                W(ind(i),k,2)=-X(ind(i),xi);
            end
            Dl=[];
            for j=1:length(D)
                if (-W(ind(i),k,1)<X(ind(i),D(j)))&(X(ind(i),D(j))<-W(ind(i),k,2))
                    Dl=[Dl,D(j)];
                end
            end
        end
        D=Dl;
    end
    y=SLMP(p,W,X);
    erro(k)=norm(y-c,1)/M;
    misc=find(abs(y-c).*[1:M]);
    
    if nargin>2
         yV=SLMP(p,W,V);
         EV(k)=norm(yV-cV,1)/MV;
    	   if nargin>4
        		yT=SLMP(p,W,T);
        		ET(k)=norm(yT-cT,1)/MT;
            disp([k,erro(k),EV(k),ET(k)]);
         else
            disp([k,erro(k),EV(k)]);
         end
    else
        disp([k,erro(k)]);
    end
end
           